/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.architectury.registry;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Objects;
import java.util.function.Supplier;
import me.shedaniel.architectury.registry.forge.ColorHandlersImpl;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ColorHandlers {
    private ColorHandlers() {
    }

    public static void registerItemColors(IItemColor color, IItemProvider ... items) {
        Supplier[] array = new Supplier[items.length];
        for (int i = 0; i < items.length; ++i) {
            IItemProvider item = Objects.requireNonNull(items[i], "items[i] is null!");
            array[i] = () -> item;
        }
        ColorHandlers.registerItemColors(color, array);
    }

    public static void registerBlockColors(IBlockColor color, Block ... blocks) {
        Supplier[] array = new Supplier[blocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            Block block = Objects.requireNonNull(blocks[i], "blocks[i] is null!");
            array[i] = () -> block;
        }
        ColorHandlers.registerBlockColors(color, array);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemColors(IItemColor color, Supplier<? extends IItemProvider> ... items) {
        void var1_1;
        ColorHandlersImpl.registerItemColors(color, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockColors(IBlockColor color, Supplier<? extends Block> ... blocks) {
        void var1_1;
        ColorHandlersImpl.registerBlockColors(color, var1_1);
    }
}

